VERSION 5.00
Object = "{19B7F2A2-1610-11D3-BF30-1AF820524153}#1.1#0"; "ccrpftv6.ocx"
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Select a file... (FTV VB6)"
   ClientHeight    =   3795
   ClientLeft      =   1995
   ClientTop       =   3330
   ClientWidth     =   5895
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   253
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   393
   Begin CCRPFolderTV6.FolderTreeview FolderTreeview1 
      Height          =   2220
      Left            =   180
      TabIndex        =   2
      Top             =   945
      Width           =   2655
      _ExtentX        =   4683
      _ExtentY        =   3916
   End
   Begin VB.CommandButton Command2 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   345
      Left            =   4560
      TabIndex        =   5
      Top             =   3360
      Width           =   1125
   End
   Begin VB.CommandButton Command1 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   345
      Left            =   3300
      TabIndex        =   4
      Top             =   3360
      Width           =   1125
   End
   Begin VB.FileListBox File1 
      Height          =   2820
      Hidden          =   -1  'True
      Left            =   3060
      System          =   -1  'True
      TabIndex        =   3
      Top             =   360
      Width           =   2655
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   180
      TabIndex        =   1
      Top             =   375
      Width           =   2655
   End
   Begin VB.Label Label1 
      Height          =   225
      Left            =   180
      TabIndex        =   0
      Top             =   90
      Width           =   5595
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates using the FolderTreeview control with Visual Basic's
' intrinsic DrvListBox and DirListBox controls.
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

' Mod level variable holding the last valid drive Drive1 was set to...
Dim m_sGoodDrive As String
'

Private Sub Form_Load()
  
  Set Icon = Nothing
  Move (Screen.Width - Width) * 0.5, (Screen.Height - Height) * 0.5
  
  FolderTreeview1.TabIndex = 2
  FolderTreeview1.OverlayIcons = False
  
  Call Drive1_Change

End Sub

Private Sub Drive1_Change()
  Dim sDrive As String
  
  ' Get the current drive and determine if the drive is available...
  sDrive = UCase(Left$(Drive1, 2) & "\")
  If IsExplicitFolderPath(sDrive) Then
    
    ' Set the FolderTreeview's root folder. If the drive were not available,
    ' then the FTV would detect this and default to the desktop folder
    FolderTreeview1.RootFolder = sDrive
   
   ' Save the current drive
    m_sGoodDrive = sDrive
  
    ' Select the drive, invoking a FolderTreeview1_SelectionChange
    FolderTreeview1.RootFolder.Selected = True
    
  Else
    ' The drive is not available, show our msgbox.
    MsgBox sDrive & " is unavailable.", vbExclamation
    
    ' Restore the previous drive, will invoke this proc again.
    Drive1 = m_sGoodDrive
  
  End If

End Sub

' Occurs both before, and after, a Folder selection is changing.
' If the PreChange parameter is True, then the Folder has not
' yet been selected, the Cancel parameter can be set to False
' to prevent selection.  If PreChange is False, the Folder has
' become selected and Cancel is ignored. The FolderTreeview's
' Expanded event uses identical syntax.

' Is invoked by selecting a currently unselected folder from either:
' a user click or keyboard selection; a code selection; or the
' FolderTreeview automatically updating itself when the currently
' selected folder is either invalid, or has been changed (renamed,
' moved, deleted) and the AutoUpdate property is set to True.

Private Sub FolderTreeview1_SelectionChange(Folder As CCRPFolderTV6.Folder, _
                                                                            PreChange As Boolean, Cancel As Boolean)
  If PreChange Then
    
    ' If by chance the Folder about to be set is the desktop folder
    ' (set to a different drive than Drive1 is set to), then the drive's
    ' disk may have been removed causing the FTV's AutoUpdate
    ' property to kick in and change it's root to the desktop folder.
    ' This is default behavior (if the FTV's root is no longer valid.).
    With FolderTreeview1
      If Folder = .GetSpecialFolderName(ftvDesktop) Then
        ' We'll set Drive1 (and the FTV) to the C drive, invoking a
        ' Drive1_Change. We could (and should) set Cancel to True
        ' here, but since we're changing the FTV's root folder, the FTV
        ' will figure it out and not process the desktop folder's selection.
        Drive1 = "c:\"
      End If
    End With
    
  Else   ' PreChange = False
  
    ' Set File1's contents
    File1.Path = Folder.FullPath
    If File1.ListCount Then
    ' Select the first file in File1, invokes a File1_Click
      File1.ListIndex = 0
    Else
      ' No files in this folder, use the folder's path
      Label1 = File1.Path
    End If
  
  End If   ' PreChange = False

End Sub

Private Sub File1_Click()
  Label1 = NormalizePath(File1.Path) & File1
End Sub

Private Sub Command1_Click()
  ' your code here...
  MsgBox Label1
  Unload Me
End Sub

Private Sub Command2_Click()
  ' your code here...
  Unload Me
End Sub

Private Function NormalizePath(ByVal sPath As String) As String
  If Right$(sPath, 1) = "\" Then
    NormalizePath = sPath
  Else
    NormalizePath = sPath & "\"
  End If
End Function
  
' Returns True if sPath is a valid file system or UNC folder path.
' Used to validate Drive1's Drive property.

Private Function IsExplicitFolderPath(ByVal sPath As String) As Boolean
  On Error GoTo Out
  
  ' Prevents relative finds...
  If Left$(sPath, 2) = "\\" Or Mid$(sPath, 2, 2) = ":\" Then
    
    ' Will err if sPath points to a file
    IsExplicitFolderPath = Len(Dir$(NormalizePath(sPath) & "*.*", _
                                                    vbDirectory Or vbHidden Or _
                                                    vbReadOnly Or vbSystem))   ' 23
  End If

Out:
End Function
